# Swift Syntax 600 Release Notes

## New APIs
- FixIt now has a new computed property named `edits`
  - Description: the `edits` represent the non-overlapping textual `edits` that need to be performed when the Fix-It is applied.
  - Issue: https://github.com/swiftlang/sourcekit-lsp/issues/909
  - Pull Request: https://github.com/swiftlang/swift-syntax/pull/2314

- `SourceEdit`
  - Description: `SourceEdit` has been moved from SwiftRefactor to SwiftSyntax
  - Issue: https://github.com/swiftlang/sourcekit-lsp/issues/909
  - Pull Request: https://github.com/swiftlang/swift-syntax/pull/2314

- `assertMacroExpansion` now have new parameters named `applyFixIts` and `fixedSource`
  - Description: `applyFixIts` and `fixedSource` are used to assert so ensure that the source code after applying Fix-Its matches this string.
  - Issue: https://github.com/swiftlang/swift-syntax/issues/2015
  - Pull Request: https://github.com/swiftlang/swift-syntax/pull/2021

- `DeclSyntaxEnum`, `StmtSyntaxEnum`, `ExprSyntaxEnum`, `TypeSyntaxEnum`, and `PatternSyntaxEnum`
  - Description: Enum to exhaustively switch over all different syntax nodes of each base type.
  - Pull Request: https://github.com/swiftlang/swift-syntax/pull/2351

- `WithOptionalCodeBlock`
  - Description: A trait for syntax nodes that have an optional code block, such as `FunctionDeclSyntax` and `InitializerDeclSyntax`.
  - Pull Request: https://github.com/swiftlang/swift-syntax/pull/2359

- `CodeBlockSyntax`
  - Description: `CodeBlockSyntax` is now `SyntaxParseable`, so it can be used with string interpolations.
  - Pull Request: https://github.com/swiftlang/swift-syntax/pull/2361

- `ThrowsClause`
  - Description: The `throwsSpecifier` for the effects nodes (`AccessorEffectSpecifiers`, `FunctionEffectSpecifiers`, `TypeEffectSpecifiers`, `EffectSpecifiers`) has been replaced with `throwsClause`, which captures both the throws specifier and the (optional) thrown error type, as introduced by SE-0413.
  - Pull Request: https://github.com/swiftlang/swift-syntax/pull/2379

- `String.isValidSwiftIdentifier(for:)`
  - Description: `SwiftParser` adds an extension on `String` to check if it can be used as an identifier in a given context.
  - Pull Request: https://github.com/swiftlang/swift-syntax/pull/2434

- `MacroDeclSyntax.expand`
  - the `expand(argumentList:definition:replacements:)` method gains a new parameter 'genericReplacements:' that is defaulted to an empty array.
  - The method's signature is now `expand(argumentList:definition:replacements:genericReplacements:)`
  - Pull Request: https://github.com/swiftlang/swift-syntax/pull/2450

- `SyntaxProtocol.asMacroLexicalContext()` and `allMacroLexicalContexts(enclosingSyntax:)`
  - Description: Produce the lexical context for a given syntax node (if it has one), or the entire stack of lexical contexts enclosing a syntax node, for use in macro expansion.
  - Pull request: https://github.com/swiftlang/swift-syntax/pull/1554

- `TriviaPiece.isComment`
  - Description: `TriviaPiece` now has a computed property `isComment` that returns `true` if the trivia piece is a comment.
  - Pull Request: https://github.com/swiftlang/swift-syntax/pull/2469

- New `assertMacroExpansion` API with option to specify macro specifications with `macroSpecs` argument
  - Description: `macroSpecs` can have additional specifications like conformances provided by member or extension macro that can be used for macro expansion.
  - Issue: https://github.com/swiftlang/swift-syntax/issues/2031
  - Pull Request: https://github.com/swiftlang/swift-syntax/pull/2327

- `BasicFormat.inferIndentation(of:)`
  - Description: Uses heuristics to infer the indentation width used in a syntax tree.
  - Pull Request: https://github.com/swiftlang/swift-syntax/pull/2514

- `IncrementalEdit` stores replacement text
  - Description: `IncrementalEdit` used to store the range that was replaced and the length of the replacement but not the replacement bytes by itself. `IncrementalEdit` now has a `replacement` property that contains the replacement bytes.
  - Pull Request: https://github.com/swiftlang/swift-syntax/pull/2527

- Type specifiers
  - Description: `AttributedTypeSyntax` can now contain multiple specifiers and these types are used to model the list of specifiers. Additionally, type specifiers can now contain arguments, like `borrow(data)`. To facilitate this, the following new types were introduces: `LifetimeSpecifierArgumentListSyntax`, `LifetimeSpecifierArgumentSyntax`, `LifetimeSpecifierArgumentsSyntax`, `LifetimeTypeSpecifierSyntax`, `SimpleTypeSpecifierSyntax`, `TypeSpecifierListSyntax`
  - Pull request: https://github.com/swiftlang/swift-syntax/pull/2433

- `DeclGroupSyntax.introducer`
  - Description: The `DeclGroupSyntax` trait has an extra `introducer` property, ie. the keyword that introduces the declaration.
  - Issue: https://github.com/swiftlang/swift-syntax/issues/2535
  - Pull Request: https://github.com/swiftlang/swift-syntax/pull/2539

- `ExprSyntax.interpretedAsVersionTuple`
  - Description: With the change to parse `#if canImport(MyModule, _version: 1.2.3)` as a function call instead of a dedicated syntax node, `1.2.3` natively gets parsed as a member access `3` to the `1.2` float literal. This property allows the reinterpretation of such an expression as a version tuple.
  - Pull request: https://github.com/swiftlang/swift-syntax/pull/2025

- `SyntaxProtocol.node(at:)`
  - Description: Given a `SyntaxIdentifier`, returns the `Syntax` node with that identifier
  - Pull request: https://github.com/swiftlang/swift-syntax/pull/2594

- `SyntaxIdentifier.IndexInTree`
  - Description: Uniquely identifies a syntax node within a tree. This is similar to ``SyntaxIdentifier`` but does not store the root ID of the tree. It can thus be transferred across trees that are structurally equivalent, for example two copies of the same tree that live in different processes. The only public functions on this type are `toOpaque` and `init(fromOpaque:)`, which allow serialization of the `IndexInTree`.
  - Pull request: https://github.com/swiftlang/swift-syntax/pull/2594

- `SyntaxIdentifier` conformance to `Comparable`:
  - Description: A `SyntaxIdentifier` compares less than another `SyntaxIdentifier` if the node at that identifier occurs first during a depth-first traversal of the tree.
  - Pull request: https://github.com/swiftlang/swift-syntax/pull/2594

- `SyntaxIdentifier.indexInTree` and `SyntaxIdentifier.fromIndexInTree`
  - Description: `SyntaxIdentifier.indexInTree` allows the retrieval of a `SyntaxIdentifier` that identifies the syntax node independent of the syntax tree. `SyntaxIdentifier.fromIndexInTree` allows the creation for a `SyntaxIdentifier` from a tree-agnostic `SyntaxIdentifier.IndexInTree` and the tree's root node.
  - Pull request: https://github.com/swiftlang/swift-syntax/pull/2594

- `Range<AbsolutePosition>`
  - Description: `Range<AbsolutePosition>` gained a few convenience functions inspired from `ByteSourceRange`: `init(position:length:)`,  `length`, `overlapsOrTouches`
  - Pull request: https://github.com/swiftlang/swift-syntax/pull/2587

- `SwiftSyntaxMacrosGenericTestSupport`
  - Description: A version of the `SwiftSyntaxMacrosTestSupport` module that doesn't depend on `Foundation` or `XCTest` and can thus be used to write macro tests using `swift-testing`. Since swift-syntax can't depend on swift-testing (which would incur a circular dependency since swift-testing depends on swift-syntax), users need to manually specify a failure handler like the following, that fails the swift-testing test: `Issue.record("\($0.message)", fileID: $0.location.fileID, filePath: $0.location.filePath, line: $0.location.line, column: $0.location.column)`
  - Pull request: https://github.com/swiftlang/swift-syntax/pull/2647

- `TokenSyntax.identifier`
  - Description: Adds an `identifier` property to `TokenSyntax` which returns a canonicalized representation of an identifier that strips away backticks.
  - Pull request: https://github.com/swiftlang/swift-syntax/pull/2576

## API Behavior Changes

## Deprecations

- Child Choice Node Casts
  - Description: `is`, `as`, and `cast` methods for types not contained in the choice node are marked as deprecated. The deprecated methods will emit a warning, indicating that the cast will always fail.
  - Issue: https://github.com/swiftlang/swift-syntax/issues/2092
  - Pull Request: https://github.com/swiftlang/swift-syntax/pull/2184
  - Migration steps: Remove the `is`, `as` or `cast` methods because they will always fail.

- `IncrementalParseTransition`:
  - Description: The initializer `IncrementalParseTransition.init(previousTree:edits:lookaheadRanges:reusedNodeCallback:)` is marked as deprecated. Use `IncrementalParseTransition.init(previousIncrementalParseResult:edits:reusedNodeCallback:)` instead.
  - Issue: https://github.com/swiftlang/swift-syntax/issues/2267
  - Pull request: https://github.com/swiftlang/swift-syntax/pull/2272
  - Migration steps: Call `IncrementalParseTransition.init(previousIncrementalParseResult:edits:reusedNodeCallback:)` instead.

- `MacroExpansion{Error|Warning|FixIt}Message` moved to the `SwiftSyntaxMacros` module
  - Description: Move the `MacroExpansion{Error|Warning|FixIt}Message` types from the `SwiftSyntaxMacroExpansion` module to `SwiftSyntaxMacros`. Deprecated typealiases in `SwiftSyntaxMacroExpansion` forward to `SwiftSyntaxMacros`.
  - Pull request: https://github.com/swiftlang/swift-syntax/pull/2338
  - Notes: The expansion diagnostic messages were defined in `SwiftSyntaxMacroExpansion`, which is intended as an implementation detail of the plugin server and should not need to be imported by macros.

- `EditorPlaceholderDeclSyntax` and `EditorPlaceholderExprSyntax`:
  - Description: `EditorPlaceholderDeclSyntax` and `EditorPlaceholderExprSyntax` are now deprecated and placeholders are instead parsed as identifiers within a `MissingDeclSyntax` or `DeclReferenceExprSyntax`.
  - Pull request: https://github.com/swiftlang/swift-syntax/pull/2237

- `AttributedTypeSyntax.specifier` has renamed to `specifiers` and changed to be a collection
  - Description: Types can have multiple specifiers now and the syntax tree has been modified to reflect that.
  - Pull request: https://github.com/swiftlang/swift-syntax/pull/2433

- `CanImportExprSyntax` and `CanImportVersionInfoSyntax`
  - Description: Instead of parsing `canImport` inside `#if` directives as a special expression node, parse it as a function call expression. This is in-line with how the `swift(>=6.0)` and `compiler(>=6.0)` directives are parsed.
  - Pull request: https://github.com/swiftlang/swift-syntax/pull/2025

- `SyntaxClassifiedRange.offset`, `length` and `endOffset`
  - Description: Deprecated these properties in favor of `range`.
  - Pull request: https://github.com/swiftlang/swift-syntax/pull/2587

- `SyntaxProtocol.totalByteRange` and `trimmedByteRange`
  - Description: Renamed to `range` and `trimmedRange`, both now returning a `Range<AbsolutePosition>`.
  - Pull request: https://github.com/swiftlang/swift-syntax/pull/2587

- `ByteSourceRange` deprecated in favor of `Range<AbsolutePosition>`
  - Description: `ByteSourceRange` is being dropped for `Range<AbsolutePosition>`, where the latter clearly signifies that it uses UTF-8 byte positions. `Range<AbsolutePosition>` has deprecated compatibility layers to make it API-compatible with `ByteSourceRange`
  - Pull request: https://github.com/swiftlang/swift-syntax/pull/2587

## API-Incompatible Changes

- `MacroDefinition` used for expanding macros:
  - Description: The `MacroDefinition/expansion` enum case used to have two values (`(MacroExpansionExprSyntax, replacements: [Replacement])`), has now gained another value in order to support generic argument replacements in macro expansions: `(MacroExpansionExprSyntax, replacements: [Replacement], genericReplacements: [GenericArgumentReplacement])`
  - Pull request: https://github.com/swiftlang/swift-syntax/pull/2450
  - Migration steps: Code which exhaustively checked over the enum should be changed to `case .expansion(let node, let replacements, let genericReplacements):`. Creating the `.extension` gained a compatibility shim, retaining the previous syntax source compatible (`return .expansion(node, replacements: [])`).

- Effect specifiers:
  - Description: The `unexpectedAfterThrowsSpecifier` node of the various effect specifiers has been removed.
  - Pull request: https://github.com/swiftlang/swift-syntax/pull/2219
  - Migration steps: Check `unexpectedBetweenThrowsSpecifierAndThrownError` and `unexpectedAfterThrownError` instead.

- `SyntaxKind` removed conformance to `CaseIterable`
  - Description: `SyntaxKind` no longer conforms to `CaseIterable` since there is no good use case to iterate over all syntax kinds.
  - Pull request: https://github.com/swiftlang/swift-syntax/pull/2292
  - Migration steps: Exhaustively check all the syntax nodes that your program supports. There should be no use case to iterate over all cases in `SyntaxKind`.

- `IntegerLiteralExprSyntax.Radix` removed conformance to `CaseIterable`
  - Description: `IntegerLiteralExprSyntax.Radix` no longer conforms to `CaseIterable` since there is no good use case to iterate over all radix kinds.
  - Pull request: https://github.com/swiftlang/swift-syntax/pull/2292
  - Migration steps: There should be no use case to iterate over all cases in `IntegerLiteralExprSyntax.Radix`.

- `Parser.parseIncrementally(source:parseTransition:)` and `Parser.parseIncrementally(source:maximumNestingLevel:parseTransition:)`:
  - Description: The default versions of `Parser.parseIncrementally` return a `IncrementalParseResult` instead of a tuple. Access to the struct should be compatible with the tuple in almost all cases unless the tuple is stored into a variable and then destructed or passed to a function that expects a tuple.
  - Issue: https://github.com/swiftlang/swift-syntax/issues/2267
  - Pull request: https://github.com/swiftlang/swift-syntax/pull/2272
  - Migration steps: If necessary, change type annotations from the tuple to the `IncrementalParseResult` type.

- `SyntaxClassification` gained a new case: `argumentLabel`
  - The new classification case covers the first names of parameters in function-like declarations and the label of arguments in function-like calls.
  - Pull request: https://github.com/swiftlang/swift-syntax/pull/2375
  - Migration steps: In exhaustive switches over `SyntaxClassification`, cover the new case.

- `SyntaxEnum` and `SyntaxKind` gained new cases: `throwsClause`
  - The new cases cover the newly introduced `ThrowsClauseSyntax`
  - Pull request: https://github.com/swiftlang/swift-syntax/pull/2379
  - Migration steps: In exhaustive switches over `SyntaxEnum` and `SyntaxKind`, cover the new case.

- `MacroExpansionContext` now requires a property `lexicalContext`:
  - Description: The new property provides the lexical context in which the macro is expanded, and has several paired API changes. Types that conform to `MacroExpansionContext` will need to implement this property. Additionally, the `HostToPluginMessage` cases `expandFreestandingMacro` and `expandAttachedMacro` now include an optional `lexicalContext`. Finally, the `SyntaxProtocol.expand(macros:in:indentationWidth:)` syntactic expansion operation has been deprecated in favor of a new version `expand(macros:contextGenerator:indentationWidth:)` that takes a function produces a new macro expansion context for each expansion.
  - Pull request: https://github.com/swiftlang/swift-syntax/pull/1554
  - Migration steps: Add the new property `lexicalContext` to any `MacroExpansionContext`-conforming types. If implementing the host-to-plugin message protocol, add support for `lexicalContext`. For macro expansion operations going through `SyntaxProtocol.expand`, provide a context generator that creates a fresh context including the lexical context.

- `TriviaPiece.isBackslash` in `SwiftParserDiagnostics` removed
  - Description: `TriviaPiece.isBackslash` was not intended to be public API.
  - Pull request: https://github.com/swiftlang/swift-syntax/pull/2531
  - Migration steps: Use `if case .backslash = triviaPiece` instead

- All symbols in `SwiftCompilerPluginMessageHandling` are now SPI
  - Description: This module is only intended to be used from some internal components. Any other modules should not use them directly.
  - Pull request: https://github.com/swiftlang/swift-syntax/pull/2489
  - Migration steps: Stop using this module.

- `ByteSourceRange.length` changed from `Int` to `SourceLength`
  - Description: `ByteSourceRange` has been deprecated and declared as a typealias for `Range<AbsolutePosition>`. At the same time, `Range<AbsolutePosition>` gained `length: SourceLength` that provides type-system information about the kind of length (UTF-8 byte length).
  - Pull request: https://github.com/swiftlang/swift-syntax/pull/2587

- `IncrementalEdit.replacementLength` changed from `Int` to `SourceLength`
  - Description: The type of `IncrementalEdit.replacementLength` has been changed from `Int` to `SourceLength` which provides type-system information about the kind of length (UTF-8 byte length).
  - Pull request: https://github.com/swiftlang/swift-syntax/pull/2587

## API-Behavior Changes

- `SyntaxProtocol.classifications(in:)` and `SyntaxProtocol.classification(at:)` take positions relative to the root of the syntax tree instead of relative to the start of the node
  - Description: With the deprecation of `ByteSourceRange` in favor of `Range<AbsolutePosition>`, the `AbsolutePosition`s passed as the range are measured from the start of the syntax tree instead of the start of the current node.
  - Pull request: https://github.com/swiftlang/swift-syntax/pull/2587
  - Migration steps: Pass absolute positions measured from the root of the syntax tree instead of positions relative to the current node.

## Template

- *Affected API or two word description*
  - Description: *A 1-2 sentence description of the new/modified API*
  - Issue: *If an issue exists for this change, a link to the issue*
  - Pull Request: *Link to the pull request(s) that introduces this change*
  - Migration steps: Steps that adopters of swift-syntax should take to move to the new API (required for deprecations and API-incompatible changes).
  - Notes: *In case of deprecations or API-incompatible changes, the reason why this change was made and the suggested alternative*

*Insert entries in chronological order, with newer entries at the bottom*
